"use client";

import * as React from "react";
import { useTranslations } from "next-intl";
import { useForm, Controller } from "react-hook-form";
import { Input } from "@/components/ui/input";
import { Select, SelectTrigger, SelectValue, SelectContent, SelectItem } from "@/components/ui/select";
import { Textarea } from "@/components/ui/textarea";
import { Button } from "@/components/ui/button";
import { API_ENDPOINTS } from "@/lib/api/endpoints";
import { useGenericTable } from "@/lib/hooks/useGenericTable";
import SubmitBtnClient from "@/components/submit-client-button";
import { RenderFields } from "@/components/common/dynamicForm";
import { Calculator, IndianRupee, Package, Save,  TrendingUp } from "lucide-react";
import { StockAdjustmentItemsTable } from "@/components/inventory/itemSelectRow";
import { LinkAsButton } from "@/components/ui/link-button";
import { Card, CardHeader, CardTitle, CardContent } from "@/components/ui/card";
import { useRouter } from "next/navigation";
import { StockAdjustmentItemsTableView } from "@/components/inventory/itemViewRow";
import { use } from "react";
import { Table,TableHeader, TableRow, TableHead, TableBody, TableCell } from "@/components/ui/table";

interface StockAdjustmentViewProps {
  params: Promise<{
    id: string;
  }>,
  searchParams: Promise<{
    user?: string;
  }>;
}

export default function StockStockUsageView({ params}: StockAdjustmentViewProps) {
  const { id } = use(params);
  const t = useTranslations("StockUsage");
  const router = useRouter();

  // Initialize table + form handling
  const url = API_ENDPOINTS.INVENTORY.STOCK_USAGE;
  const { save, loading, create, getItem } = useGenericTable({ url });
  const methods = useForm<any>();
  const [redering, setRedering] = React.useState<boolean>(true);
  const { control, handleSubmit, reset, setValue, watch } = methods;

  // const dynamicFields = [
  //   { key: "quantity", type: "number", },
  //   { key: "quantity_diff", type: "number" },
  //   { key: "unit_cost", type: "number" },
  //   { key: "note", type: "text" },
  // ];

  // Define fields in your pattern
  const [fields, setFields] = React.useState<any[]>([]);
  const [dynamicFields, setDynamic] = React.useState<any>();

 let totalValue = 0;
  React.useEffect(() => {
    (async () => {
      try {
        const data: any = await create("-create");
        const viewData: any = await getItem(id);


        setDynamic(viewData?.items)
        debugger;


        setFields([
          {
            label: t("date"),
            data: {
              type: "date",
              props: [],
              key: "usage_date",
              value: ""
            }
          },
          {
            label: t("selectStore"),
            data: {
              type: "select",
              props: data?.stores?.map((s: any) => ({ value: String(s.id), label: s.store_name })),
              key: "from_store_id",
              value: ""
            }
          },
          {
            label: t("status"),
            data: {
              type: "select",
              props: data?.status?.map((s: any) => ({ value: String(s.id), label: s.name })),
              key: "status",
              value: ""
            }
          },
          {
            label: t("notes"),
            data: {
              type: "textarea",
              props: [],
              key: "notes",
              value: ""
            }
          }
          // Add other fields if needed

        ]);
        setValue('notes', viewData?.notes)
        setValue('from_store_id', String(viewData?.store_id))
        setValue('usage_date', viewData?.usage_date)
        setRedering(false);
      } catch (error) {
        console.error("Failed to fetch stock adjustment options:", error);
      }
    })();
  }, []);


  // Submit handler
  const onSubmit = async (data: any) => {
    debugger;
    try {
      await save(data);
      reset();
      router.push("/inventory/stock/adjustment");
    } catch (error) {
      console.error(error);
    }
  };

  return (
    <form className="space-y-4">
      <div className="flex items-center justify-between">
        <h1 className="text-2xl font-semibold">{t("view_transfer")}</h1>
      </div>


      <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
        <RenderFields fields={fields} control={control} register={methods.register} t={t} redering={redering} setValue={setValue} />
      </div>

        <div>
            <div>
                <h3 className="py-3 font-medium font-thick">Item List</h3>
            </div>

            <div className="overflow-x-auto rounded-md border">
                <Table className="w-full text-sm">
                    <TableHeader>
                        <TableRow>
                            <TableHead>Item</TableHead>
                            <TableHead>Batch</TableHead>
                            <TableHead>Unit</TableHead>
                            <TableHead>Quantity</TableHead>
                            <TableHead>Unit Cost</TableHead>
                            <TableHead>Note</TableHead>{/* For Remove button */}
                        </TableRow>
                    </TableHeader>
                    <TableBody>
                        {dynamicFields?.map((item: any, index: any) => {
                          debugger
                            totalValue += item.batch.cost_price * item.quantity; // calculate total for this field

                            return (
                                <TableRow key={item.id}>
                                    <TableCell>{item.item.item_name}</TableCell>
                                    <TableCell>{item.item.batch_number}</TableCell>
                                    <TableCell>{item.unit?.name}</TableCell>
                                    <TableCell>{item.quantity}</TableCell>
                                    <TableCell>{parseFloat(item.batch.cost_price)}</TableCell>
                                    <TableCell>{item.note || ""}</TableCell>
                                </TableRow>)
                        })}
                    </TableBody>
                </Table>


            </div >

            <Card className="mt-10 ml-auto w-full md:w-1/2 shadow-sm border border-gray-100">
                <div className="p-4">

                    <CardContent className="flex flex-col gap-3 text-sm px-0">
                        <div className="flex justify-between border-b border-gray-100 pb-2">
                            <span className="text-gray-500">{t("total_items")}</span>
                            <span className="font-semibold text-gray-800">{dynamicFields?.length || 0}</span>
                        </div>

                        <div className="flex justify-between items-center pt-2">
                            <span className="text-gray-700 font-medium">{t("total_adjustment")}</span>
                            <span className="text-black-600 font-bold font-thick text-lg tracking-wide">{totalValue}</span>
                        </div>
                    </CardContent>
                </div>
            </Card>
        </div>

      <div className="mt-6 flex justify-end gap-2">
        <LinkAsButton href="/inventory/stock/adjustment" variant={"outline"} >{t("cancel")}</LinkAsButton>
      </div>
    </form>
  );
}
