"use client"

import * as React from "react"
import { useTranslations } from "next-intl"
import { Plus, Pencil, Trash2, ChevronLeft, ChevronRight, ChevronsLeft, ChevronsRight, Download, Printer, ExternalLink, Search, RefreshCcw, Edit, Eye, Grid, MoreHorizontal, History } from "lucide-react"
import { Button } from "@/components/ui/button"
import { Input } from "@/components/ui/input"
import { Checkbox } from "@/components/ui/checkbox"
import {
  Select, SelectTrigger, SelectValue, SelectContent, SelectItem
} from "@/components/ui/select"
import {
  Table, TableHeader, TableRow, TableHead, TableBody, TableCell
} from "@/components/ui/table"
import { useGenericTable } from "@/lib/hooks/useGenericTable"
import { API_ENDPOINTS } from "@/lib/api/endpoints"
import { useEffect, useState } from "react"
import { DeleteButton } from "@/components/DeleteButton"
import { TableSkeleton } from "@/components/ui/table-skeleton"
import { DynamicModal } from "@/components/common/dynamicModal"
import { useForm } from "react-hook-form"
import { toast } from "sonner"
import SubmitBtnClient from "@/components/submit-client-button"
import { Card, CardHeader, CardTitle, CardDescription, CardContent } from "@/components/ui/card"
import { LinkAsButton } from "@/components/ui/link-button"
import { Label } from "@radix-ui/react-label"
import { title } from "process"
import { debug } from "console"
import SelectServerCommon from "@/components/SelectServerCommon"
import { DropdownMenu, DropdownMenuContent, DropdownMenuItem, DropdownMenuSeparator, DropdownMenuTrigger } from "@/components/ui/dropdown-menu"

export default function SuppliersPage() {
  const url = API_ENDPOINTS.INVENTORY.STOCK_USAGE;
  const { data, loading, error, pagination, fetchData, save, deleteItem, getItem, update } = useGenericTable({ url });
  const t = useTranslations("StockUsage");
  const [editing, setEditing] = React.useState(false)
  const [searchFilters, setSearchFilters] = useState<any>([]);
  const [createModal, setCreateModal] = useState(false);
  const [form, setForm] = React.useState<any>();
  const [isSubmitting, setIsSubmitting] = useState<boolean>(false);
  const [fields, setfields] = useState<any>([]);

  const permissions = { edit: true, clone: true, delete: true }



  const handleSearch = (field: string, value: string) => {
    debugger;
    setSearchFilters((prev: any) => ({ ...prev, [field]: value }))
  }


  const buildSearchParams =
    (page: number = 1) => {
      const params = new URLSearchParams({
        page: page.toString(),
        per_page: "10",
      });

      if (searchFilters?.item_id) {
        params.set("item_id", searchFilters.item_id);
      }
      if (searchFilters?.date_from) {
        params.set("date_from", searchFilters.date_from);
      }
      if (searchFilters?.date_to) {
        params.set("date_to", searchFilters.date_to);
      }
      return params.toString();
    };

  // Fetch user when search filters change

  const search = () => {
    const params = buildSearchParams(1)
    fetchData(params)
  }

  React.useEffect(() => {
    const params = buildSearchParams(1);
    fetchData(params);
  }, []);



  // Handle pagination
  const handlePageChange = ((newPage: number) => {
    debugger;
    const params = buildSearchParams(newPage)
    fetchData(params);
  })

  const handleSave = async (methods: any) => {
    try {
      const form = methods.getValues();

      await save(form);
      debugger;
      const params = buildSearchParams(1);
      fetchData(params);
      setCreateModal(false)
      return true;

    } catch (error: any) {
      return false;
    } finally {

    }
  };

  const handleUpdate = async (methods: any) => {
    try {
      const data = methods.getValues();

      await update(data, form?.vendor_id);
      debugger;
      const params = buildSearchParams(1);
      fetchData(params);
      setEditing(false);
      return true;

    } catch (error: any) {
      return false;
    } finally {

    }
  };

  const handleDelete = async (methods: any) => {

    try {
      debugger;
      await deleteItem(methods)
      const params = buildSearchParams(1);
      fetchData(params);
    } catch (error: any) {
    } finally {

    }
  }

  return (
    <div className="p-2 space-y-6">

      <Card className="mb-6">
        <CardHeader>
          <CardTitle className="text-lg">
            <div className="flex flex-wrap items-center justify-between gap-3">
              <div className="flex items-center gap-2">
                <h2 className="text-3xl font-semibold text-gray-700">{t("title")}</h2>
              </div>

              <div className="flex items-center gap-2">
                <LinkAsButton href={'/inventory/stock/usage/create'}>
                  <Plus className="mr-2 size-4" />
                  {t("new")}
                </LinkAsButton>
                <Button variant="outline">
                  <Printer className="mr-2 size-4" />
                  {t("print")}
                </Button>
                <Button variant="outline">
                  <Download className="mr-2 size-4" />
                  {t("export")}
                </Button>
              </div>
            </div>
          </CardTitle>
          <CardDescription>{t("sup_des")}</CardDescription>
        </CardHeader>
        <CardContent>
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
            <div className="space-y-2">
              <Label htmlFor="date_from">{t("search_by") + " " + t("dateFrom")}</Label>
              <Input
                id="date_from"
                type="date"
                placeholder={`${t("search_by")} ${t("dateFrom")}`}
                value={searchFilters.date_from || ""}
                onChange={(e) => handleSearch("date_from", e.target.value)}
              />
            </div>
            <div className="space-y-2">
              <Label htmlFor="date_to">{t("search_by") + " " + t("dateTo")}</Label>
              <Input
                id="date_to"
                type="date"
                placeholder={`${t("search_by")} ${t("dateTo")}`}
                value={searchFilters.date_to || ""}
                onChange={(e) => handleSearch("date_to", e.target.value)}
              />
            </div>
            <div className="space-y-2">
              <Label htmlFor="date_to">{t("search_by") + " " + t("item")}</Label>
              <SelectServerCommon
                apiUrl={API_ENDPOINTS.INVENTORY.LIST}
                onChange={(e: any) => handleSearch("item_id", e.value)}
                placeholder={`${t("search_by")} ${t("item")}`}
              />
            </div>
            <div className="flex space-x-2 items-end h-full">
              <SubmitBtnClient isLoading={loading} onClick={() => search()} variant={"outline"}>
                <Search />
              </SubmitBtnClient>
              <SubmitBtnClient isLoading={loading} onClick={() => { setSearchFilters([]); search() }} variant="outline">
                <RefreshCcw />
              </SubmitBtnClient>
            </div>

          </div>
        </CardContent>
      </Card>

      {/* Table */}
      <div className="rounded-md border overflow-hidden space-y-4 p-1">

        <div className="flex items-center justify-between text-sm text-gray-600">
          <span>
            {pagination && (
              <div>
                Showing{" "}
                {(pagination.currentPage - 1) * pagination.itemsPerPage + 1} to{" "}
                {Math.min(
                  pagination.currentPage * pagination.itemsPerPage,
                  pagination.totalItems
                )}{" "}
                of {pagination.totalItems} entries
              </div>
            )}
          </span>
        </div>
        {loading ? (<TableSkeleton columns={6} rows={10} />) : (
          <Table>
            <TableHeader>
              <TableRow>
                <TableHead className="w-16">#</TableHead>
                <TableHead>{t("date")}</TableHead>
                <TableHead>{t("store")}</TableHead>
                <TableHead>{t("usage_inv")}</TableHead>
                <TableHead>{t("patient")}</TableHead>
                <TableHead>{t("usageBy")}</TableHead>
                <TableHead>{t("status")}</TableHead>
                <TableHead className="w-28 text-right">{t("actions")}</TableHead>
              </TableRow>
            </TableHeader>
            <TableBody>
              {data.length === 0 ? (
                <TableRow>
                  <TableCell colSpan={7} className="text-center text-muted-foreground">
                    {t("noData")}
                  </TableCell>
                </TableRow>
              ) : (
                data.map((transfer: any, i: number) => (
                  <TableRow key={transfer.id}>
                    <TableCell>{transfer.id}</TableCell>
                    <TableCell>{new Date(transfer.usage_date).toLocaleDateString()}</TableCell>
                    <TableCell>{transfer.store?.store_name ?? "-"}</TableCell>
                    <TableCell>{transfer.treatment_id ?? "-"}</TableCell>
                    <TableCell>{transfer.patient_id ?? "-"}</TableCell>
                    <TableCell>{transfer.creator?.name ?? "-"}</TableCell>
                    <TableCell>{transfer.status ?? "-"}</TableCell>
                    <TableCell className="text-right space-x-2">

                      <DropdownMenu modal={false}>
                        <DropdownMenuTrigger asChild>
                          <Button variant="ghost" className="h-8 w-8 p-0">
                            <MoreHorizontal className="h-4 w-4" />
                          </Button>
                        </DropdownMenuTrigger>
                        <DropdownMenuContent align="end">
                          <DropdownMenuItem
                          >

                            <LinkAsButton
                              variant="ghost"
                              href={`/inventory/stock/usage/view/${transfer.id}`}
                            >
                              <Eye className="mr-2 h-4 w-4" />
                              View
                            </LinkAsButton>
                          </DropdownMenuItem>
                          {permissions.edit && (
                            <DropdownMenuItem
                              className="cursor-pointer"
                            >
                              <LinkAsButton
                                variant="ghost"
                                href={`/inventory/stock/usage/${transfer.id}`}
                              >
                                <Edit className="mr-2 h-4 w-4" />
                                Edit
                              </LinkAsButton>
                            </DropdownMenuItem>
                          )}
                          {permissions.delete && (
                            <>
                              <DropdownMenuSeparator />
                              <DropdownMenuItem
                                asChild
                                onSelect={(e) => e.preventDefault()} // Prevent Dropdown auto-close
                              >
                                <div onClick={(e) => e.stopPropagation()}>
                                  <DeleteButton key={transfer.id} onConfirm={() => deleteItem(transfer.id)} />
                                  Delete
                                </div>
                              </DropdownMenuItem>
                            </>
                          )}
                        </DropdownMenuContent>
                      </DropdownMenu>
                    </TableCell>
                  </TableRow>
                ))
              )}
            </TableBody>
          </Table>
        )}

        {pagination?.totalPages > 1 && (
          <div className="flex items-center justify-between">
            <div className="text-sm text-gray-600">
              Page {pagination.currentPage} of {pagination.totalPages}
            </div>
            <div className="flex items-center space-x-2">
              <Button
                variant="outline"
                className="hidden h-8 w-8 p-0 lg:flex"
                onClick={() => handlePageChange(1)}
                disabled={pagination.currentPage === 1}
              >
                <ChevronsLeft className="h-4 w-4" />
              </Button>
              <Button
                variant="outline"
                size="sm"
                onClick={() => handlePageChange(pagination.currentPage - 1)}
                disabled={pagination.currentPage === 1}
              >
                <ChevronLeft className="h-4 w-4" />
              </Button>
              <Button
                variant="outline"
                size="sm"
                onClick={() => handlePageChange(pagination.currentPage + 1)}
                disabled={pagination.currentPage === pagination.totalPages}
              >
                <ChevronRight className="h-4 w-4" />
              </Button>
              <Button
                variant="outline"
                className="hidden h-8 w-8 p-0 lg:flex"
                onClick={() => handlePageChange(pagination.totalPages)}
                disabled={pagination.currentPage === pagination.totalPages}
              >
                <ChevronsRight className="h-4 w-4" />
              </Button>
            </div>
          </div>
        )}

      </div>
    </div>
  )
}
