"use client";

import * as React from "react";
import { useTranslations } from "next-intl";
import { useForm, Controller } from "react-hook-form";
import { Input } from "@/components/ui/input";
import { Select, SelectTrigger, SelectValue, SelectContent, SelectItem } from "@/components/ui/select";
import { Textarea } from "@/components/ui/textarea";
import { Button } from "@/components/ui/button";
import { API_ENDPOINTS } from "@/lib/api/endpoints";
import { useGenericTable } from "@/lib/hooks/useGenericTable";
import SubmitBtnClient from "@/components/submit-client-button";
import { RenderFields } from "@/components/common/dynamicForm";
import { Calculator, IndianRupee, Package, Save, TrendingUp } from "lucide-react";
import { StockAdjustmentItemsTable } from "@/components/inventory/itemSelectRow";
import { LinkAsButton } from "@/components/ui/link-button";
import { Card, CardHeader, CardTitle, CardContent } from "@/components/ui/card";
import { useRouter } from "next/navigation";
// import router from "next/router";

export default function StockAdjustmentCreate() {
  const t = useTranslations("StockAdjustment");
       const router = useRouter();

  // Initialize table + form handling
  const url = API_ENDPOINTS.INVENTORY.STOCK_ADJUSTMENT;
  const { save, loading, create, } = useGenericTable({ url });
  const methods = useForm<any>();
  const [redering, setRedering] = React.useState<boolean>(true);
  const { control, handleSubmit, reset, setValue, watch } = methods;

  const dynamicFields = [
    { key: "quantity", type: "number" },
    { key: "quantity_diff", type: "number" },
    { key: "unit_cost", type: "number" },
    { key: "note", type: "text" },
  ];

  // Define fields in your pattern
  const [fields, setFields] = React.useState<any[]>([]);


  React.useEffect(() => {
    (async () => {
      try {
        const data: any = await create('-create');

        setFields([
          {
            label: t("date"),
            data: {
              type: "date",
              props: [],
              key: "date",
              value: new Date().toISOString().split('T')[0]
            }
          },
          {
            label: t("adjustmentReason"),
            data: {
              type: "select",
              props: data?.reasons?.map((r: any) => ({ value: String(r.id), label: r.name })),
              key: "reason",
              value: ""
            }
          },
          {
            label: t("adjustmentAccount"),
            data: {
              type: "select",
              props: data?.accounts?.map((a: any) => ({ value: String(a.id), label: a.name })),
              key: "account",
              value: ""
            }
          },
          {
            label: t("store"),
            data: {
              type: "select",
              props: data?.stores?.map((s: any) => ({ value: String(s.id), label: s.store_name })),
              key: "store",
              value: ""
            }
          },
          // Add other fields if needed

        ]);
        setRedering(false);
      } catch (error) {
        console.error("Failed to fetch stock adjustment options:", error);
      }
    })();
  }, []);


  // Submit handler
  const onSubmit = async (data: any) => {
    debugger;
    try {
      await save(data);
      router.push("/inventory/stock/adjustment");
    } catch (error) {
      console.error(error);
    }
  };

  return (
    <form className="space-y-4">
      <div className="flex items-center justify-between">
        <h1 className="text-2xl font-semibold">{t("addNewItemTitle")}</h1>
      </div>


      <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
        <RenderFields fields={fields} control={control} register={methods.register} t={t} redering={redering} />
      </div>

      <StockAdjustmentItemsTable
        control={control}
        watch={watch}
        methods={methods}
        setValue={setValue}
        dynamicFields={dynamicFields}
        t={t}
      />

      <div className="mt-6 flex justify-end gap-2">
        <LinkAsButton href="/inventory/stock/adjustment" variant={"outline"} >{t("cancel")}</LinkAsButton>
        <SubmitBtnClient isLoading={loading} onClick={handleSubmit(onSubmit)} ><Save />{t("saveAdjustment")}</SubmitBtnClient>
      </div>
    </form>
  );
}
